/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.data;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.neoforged.neoforge.common.crafting.IntersectionIngredient;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.block.ModBlocks;
import net.zlt.create_vibrant_vaults.block.VerticalVaultBlock;
import net.zlt.create_vibrant_vaults.block.VibrantPackagerBlock;
import net.zlt.create_vibrant_vaults.block.VibrantRedstoneRequesterBlock;
import net.zlt.create_vibrant_vaults.block.VibrantVaultBlock;
import net.zlt.create_vibrant_vaults.item.ModItemTags;

public class CreateVibrantVaultsRecipeProvider
extends RecipeProvider {
    public CreateVibrantVaultsRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AllBlocks.FACTORY_GAUGE, (int)2).requires(ModItemTags.VIBRANT_STOCK_LINKS.tag).requires((ItemLike)AllItems.PRECISION_MECHANISM).unlockedBy("has_stock_link", CreateVibrantVaultsRecipeProvider.has(ModItemTags.VIBRANT_STOCK_LINKS.tag)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName((ItemLike)AllBlocks.FACTORY_GAUGE) + "_from_vibrant_stock_links");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)AllBlocks.STOCK_TICKER).define(Character.valueOf('A'), ModItemTags.VIBRANT_STOCK_LINKS.tag).define(Character.valueOf('B'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('C'), Tags.Items.GLASS_BLOCKS).pattern("C").pattern("A").pattern("B").unlockedBy("has_item", CreateVibrantVaultsRecipeProvider.has((ItemLike)AllItems.CARDBOARD)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName((ItemLike)AllBlocks.STOCK_TICKER) + "_from_vibrant_stock_links");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AllBlocks.REPACKAGER).requires(ModItemTags.VIBRANT_PACKAGERS.tag).unlockedBy("has_packager", CreateVibrantVaultsRecipeProvider.has(ModItemTags.VIBRANT_PACKAGERS.tag)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName((ItemLike)AllBlocks.REPACKAGER) + "_from_vibrant_packagers");
        for (ModBlocks.VibrantVaultColor color : ModBlocks.VibrantVaultColor.values()) {
            Block frogport = color == ModBlocks.VibrantVaultColor.BASE ? (Block)AllBlocks.PACKAGE_FROGPORT.get() : (Block)ModBlocks.getVibrantFrogport(color).get();
            Block stockLink = color == ModBlocks.VibrantVaultColor.BASE ? (Block)AllBlocks.STOCK_LINK.get() : (Block)ModBlocks.getVibrantStockLink(color).get();
            Ingredient vibrantColorVaults = color == ModBlocks.VibrantVaultColor.BASE ? DifferenceIngredient.of((Ingredient)Ingredient.of(ModItemTags.ofColor((ModBlocks.VibrantVaultColor)color).tag), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{AllBlocks.ITEM_VAULT})) : Ingredient.of(ModItemTags.ofColor((ModBlocks.VibrantVaultColor)color).tag);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)frogport).define(Character.valueOf('A'), vibrantColorVaults).define(Character.valueOf('B'), Tags.Items.SLIMEBALLS).define(Character.valueOf('C'), (ItemLike)AllItems.ANDESITE_ALLOY).pattern("B").pattern("A").pattern("C").unlockedBy("has_item", CreateVibrantVaultsRecipeProvider.has((ItemLike)AllItems.CARDBOARD)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName((ItemLike)frogport));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)stockLink).define(Character.valueOf('B'), vibrantColorVaults).define(Character.valueOf('C'), (ItemLike)AllItems.TRANSMITTER).pattern("C").pattern("B").unlockedBy("has_item", CreateVibrantVaultsRecipeProvider.has((ItemLike)AllItems.CARDBOARD)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName((ItemLike)stockLink));
            if (color == ModBlocks.VibrantVaultColor.BASE) continue;
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)frogport).requires(ModItemTags.FROGPORTS.tag).requires((ItemLike)DyeItem.byColor((DyeColor)DyeColor.byId((int)color.ordinal()))).unlockedBy("has_frogport", CreateVibrantVaultsRecipeProvider.has(ModItemTags.FROGPORTS.tag)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName((ItemLike)frogport) + "_from_dyeing");
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)stockLink).requires((ItemLike)stockLink).unlockedBy("has_item", CreateVibrantVaultsRecipeProvider.has((ItemLike)stockLink)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName((ItemLike)stockLink) + "_clear");
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)stockLink).requires(ModItemTags.STOCK_LINKS.tag).requires((ItemLike)DyeItem.byColor((DyeColor)DyeColor.byId((int)color.ordinal()))).unlockedBy("has_stock_link", CreateVibrantVaultsRecipeProvider.has(ModItemTags.STOCK_LINKS.tag)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName((ItemLike)stockLink) + "_from_dyeing");
            BlockEntry<VibrantRedstoneRequesterBlock> redstoneRequester = ModBlocks.getVibrantRedstoneRequester(color);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, redstoneRequester).define(Character.valueOf('A'), (ItemLike)stockLink).define(Character.valueOf('B'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), Tags.Items.DUSTS_REDSTONE).pattern("C").pattern("A").pattern("B").unlockedBy("has_item", CreateVibrantVaultsRecipeProvider.has((ItemLike)AllItems.CARDBOARD)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName(redstoneRequester));
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, redstoneRequester).requires(redstoneRequester).unlockedBy("has_item", CreateVibrantVaultsRecipeProvider.has(redstoneRequester)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName(redstoneRequester) + "_clear");
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, redstoneRequester).requires(ModItemTags.REDSTONE_REQUESTERS.tag).requires((ItemLike)DyeItem.byColor((DyeColor)DyeColor.byId((int)color.ordinal()))).unlockedBy("has_redstone_requester", CreateVibrantVaultsRecipeProvider.has(ModItemTags.REDSTONE_REQUESTERS.tag)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName(redstoneRequester) + "_from_dyeing");
            BlockEntry<VibrantPackagerBlock> packager = ModBlocks.getVibrantPackager(color);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, packager).requires(ModItemTags.PACKAGERS.tag).requires((ItemLike)DyeItem.byColor((DyeColor)DyeColor.byId((int)color.ordinal()))).unlockedBy("has_packager", CreateVibrantVaultsRecipeProvider.has(ModItemTags.PACKAGERS.tag)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName(packager));
            for (ModBlocks.VibrantVaultType type2 : ModBlocks.VibrantVaultType.values()) {
                BlockEntry<VibrantVaultBlock> horizontalVault = ModBlocks.getVibrantVault(type2, color, false);
                Ingredient typeAndHorizontalIngredient = IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ModItemTags.ofType((ModBlocks.VibrantVaultType)type2).tag), Ingredient.of(ModItemTags.ofOrientation((boolean)false).tag)});
                ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, horizontalVault).requires(typeAndHorizontalIngredient).requires((ItemLike)DyeItem.byColor((DyeColor)DyeColor.byId((int)color.ordinal()))).unlockedBy("has_vault", CreateVibrantVaultsRecipeProvider.has(ModItemTags.VAULTS.tag)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName(horizontalVault) + "_from_dyeing");
                BlockEntry<VibrantVaultBlock> verticalVault = ModBlocks.getVibrantVault(type2, color, true);
                Ingredient typeAndVerticalIngredient = IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ModItemTags.ofType((ModBlocks.VibrantVaultType)type2).tag), Ingredient.of(ModItemTags.ofOrientation((boolean)true).tag)});
                ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, verticalVault).requires(typeAndVerticalIngredient).requires((ItemLike)DyeItem.byColor((DyeColor)DyeColor.byId((int)color.ordinal()))).unlockedBy("has_vault", CreateVibrantVaultsRecipeProvider.has(ModItemTags.VAULTS.tag)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName(verticalVault) + "_from_dyeing");
            }
        }
        for (List list : ModBlocks.VIBRANT_VAULTS) {
            for (BlockEntry vault : list) {
                VibrantVaultBlock block = (VibrantVaultBlock)((Object)vault.get());
                String colorId = block.color.asId();
                boolean vertical = block instanceof VerticalVaultBlock;
                Ingredient colorAndOrientationIngredient = DifferenceIngredient.of((Ingredient)IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ModItemTags.ofColor((ModBlocks.VibrantVaultColor)block.color).tag), Ingredient.of(ModItemTags.ofOrientation((boolean)vertical).tag)}), (Ingredient)Ingredient.of(ModItemTags.ofType((ModBlocks.VibrantVaultType)block.type).tag));
                SingleItemRecipeBuilder.stonecutting((Ingredient)colorAndOrientationIngredient, (RecipeCategory)RecipeCategory.MISC, (ItemLike)vault).unlockedBy("has_" + colorId + "_" + (vertical ? "vertical" : "horizontal") + "_vault", CreateVibrantVaultsRecipeProvider.has(ModItemTags.VAULTS.tag)).save(output, "create_vibrant_vaults:stonecutting/" + CreateVibrantVaultsRecipeProvider.getItemName((ItemLike)vault) + "_from_" + colorId + "_" + (vertical ? "vertical" : "horizontal") + "_vaults");
                BlockEntry<VibrantVaultBlock> rotatedVault = block.type == ModBlocks.VibrantVaultType.ITEM_VAULT && block.color == ModBlocks.VibrantVaultColor.BASE ? AllBlocks.ITEM_VAULT : ModBlocks.getVibrantVault(block.type, block.color, !vertical);
                ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)vault).requires(rotatedVault).unlockedBy("has_rotated_vault", CreateVibrantVaultsRecipeProvider.has(rotatedVault)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName((ItemLike)vault) + "_from_rotating");
            }
        }
        Ingredient colorAndOrientationIngredient = DifferenceIngredient.of((Ingredient)IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ModItemTags.BASE_VAULTS.tag), Ingredient.of(ModItemTags.HORIZONTAL_VAULTS.tag)}), (Ingredient)Ingredient.of(ModItemTags.ITEM_VAULTS.tag));
        String string = ModBlocks.VibrantVaultColor.BASE.asId();
        SingleItemRecipeBuilder.stonecutting((Ingredient)colorAndOrientationIngredient, (RecipeCategory)RecipeCategory.MISC, (ItemLike)AllBlocks.ITEM_VAULT).unlockedBy("has_" + string + "_horizontal_vault", CreateVibrantVaultsRecipeProvider.has(ModItemTags.VAULTS.tag)).save(output, "create_vibrant_vaults:stonecutting/" + CreateVibrantVaultsRecipeProvider.getItemName((ItemLike)AllBlocks.ITEM_VAULT) + "_from_" + string + "_horizontal_vaults");
        BlockEntry<VibrantVaultBlock> rotatedVault = ModBlocks.getVibrantVault(ModBlocks.VibrantVaultType.ITEM_VAULT, ModBlocks.VibrantVaultColor.BASE, true);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)AllBlocks.ITEM_VAULT).requires(rotatedVault).unlockedBy("has_rotated_vault", CreateVibrantVaultsRecipeProvider.has(rotatedVault)).save(output, "create_vibrant_vaults:crafting/" + CreateVibrantVaultsRecipeProvider.getItemName((ItemLike)AllBlocks.ITEM_VAULT) + "_from_" + CreateVibrantVaultsRecipeProvider.getItemName(rotatedVault));
        CreateProcessingRecipeProvider.of((IRecipeTypeInfo)AllRecipeTypes.SPLASHING, output).forEach(ModBlocks.VibrantVaultType.values(), (p, type) -> List.of(p.recipe(type.asId(false) + "_color_washing", b -> b.require(ModItemTags.ofColored((ModBlocks.VibrantVaultType)type, (boolean)false).tag).output((ItemLike)(type == ModBlocks.VibrantVaultType.ITEM_VAULT ? AllBlocks.ITEM_VAULT : ModBlocks.getVibrantVault(type, ModBlocks.VibrantVaultColor.BASE, false)))), p.recipe(type.asId(true) + "_color_washing", b -> b.require(ModItemTags.ofColored((ModBlocks.VibrantVaultType)type, (boolean)true).tag).output(ModBlocks.getVibrantVault(type, ModBlocks.VibrantVaultColor.BASE, true))))).add("frogport_color_washing", b -> b.require(ModItemTags.VIBRANT_FROGPORTS.tag).output((ItemLike)AllBlocks.PACKAGE_FROGPORT)).add("stock_link_color_washing", b -> b.require(ModItemTags.VIBRANT_STOCK_LINKS.tag).output((ItemLike)AllBlocks.STOCK_LINK)).add("redstone_requester_color_washing", b -> b.require(ModItemTags.VIBRANT_REDSTONE_REQUESTERS.tag).output((ItemLike)AllBlocks.REDSTONE_REQUESTER)).add("packager_color_washing", b -> b.require(ModItemTags.VIBRANT_PACKAGERS.tag).output((ItemLike)AllBlocks.PACKAGER));
    }

    public static abstract class CreateProcessingRecipeProvider {
        public static CreateProcessingRecipeProvider of(final IRecipeTypeInfo recipeType, final RecipeOutput output) {
            return new CreateProcessingRecipeProvider(){

                @Override
                public IRecipeTypeInfo getRecipeType() {
                    return recipeType;
                }

                @Override
                public void register(CreateRecipeProvider.GeneratedRecipe recipe) {
                    recipe.register(output);
                }
            };
        }

        public <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe recipe(String name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
            return output -> ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(((ProcessingRecipeSerializer)this.getRecipeType().getSerializer()).getFactory(), CreateVibrantVaults.asResource(name)))).build(output);
        }

        public <T extends ProcessingRecipe<?>> CreateProcessingRecipeProvider add(String name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
            this.register(this.recipe(name, transform));
            return this;
        }

        public <T> CreateProcessingRecipeProvider forEach(T[] values, BiFunction<CreateProcessingRecipeProvider, T, List<CreateRecipeProvider.GeneratedRecipe>> recipes) {
            for (T value : values) {
                for (CreateRecipeProvider.GeneratedRecipe recipe : recipes.apply(this, (CreateProcessingRecipeProvider)value)) {
                    this.register(recipe);
                }
            }
            return this;
        }

        public abstract IRecipeTypeInfo getRecipeType();

        public abstract void register(CreateRecipeProvider.GeneratedRecipe var1);
    }
}

